<?php
namespace App\Http\Controllers\Provider;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Advantage;
use App\Http\Resources\AdvantageResource;
use App\Traits\ApiTrait;
use App\Models\Setting;

class StaticPagesController extends Controller
{
    use ApiTrait;

 public function index(Request $request)
    {
        try {
            $lang = $request->query('lang', 'ar'); // get ?lang=en or default to ar

            
            $terms = Advantage::where('type', 'term_conditions')->get();
            $advantages = Advantage::where('type', 'advantages')->get();

          
            $termsData = $terms->map(fn($item) => new AdvantageResource($item, $lang));
            $advantagesData = $advantages->map(fn($item) => new AdvantageResource($item, $lang));

            
            $settings = Setting::whereIn('key', ['email', 'phone', 'whatapp_phone','youtube','instagram','facebook','tiktok'])->pluck('value', 'key');

            return $this->apiResponse(true, 'Static pages content retrieved successfully', [], [
                'term_condations' => $termsData,
                'advantage'       => $advantagesData,
                'contact' => [
                    'email'    => $settings->get('email', null),
                    'phone'    => $settings->get('phone', null),
                    'whatsapp' => $settings->get('whatapp_phone', null),
                    'tiktok'    => $settings->get('tiktok', null),
                    'facebook_link'    => $settings->get('facebook', null),
                    'youtube_link' => $settings->get('youtube', null),
                     'instagram_link'    => $settings->get('instagram', null),
                ],
            ]);
        } catch (\Exception $e) {
            return $this->apiResponse(false, 'Something went wrong', 500);
        }
    }
}