<?php
namespace App\Http\Controllers\Provider;

use Illuminate\Http\Request;
use App\Models\VendorIinspection;
use App\Http\Controllers\Controller;
use App\Traits\ApiTrait;
use App\Http\Resources\InspectionResource;
class VendorInspectionController extends Controller
{
    // ✅ Store a new inspection
    use ApiTrait;
   
   
    public function index(){
          $vendor = auth()->user();
          $inspections = $vendor->inspections()->get();
        
          return $this->apiResponse(true, 'vendor inspections issue retrive successfully', [],InspectionResource::collection($inspections));

    }
  
  
  
    public function store(Request $request)
    {
         $request->validate([
          'inspection_ids' => 'required|array',
          'inspection_ids.*' => 'exists:inspections,id'
        ]);

        $vendor = auth()->user(); 

        
        $vendor->inspections()->sync($request->inspection_ids);

        $inspections = $vendor->inspections;

        return $this->apiResponse(true, 'Vendor inspections updated successfully', [],  InspectionResource::collection($inspections));
    }

    // ✅ Update an existing inspection
   
   
    public function update(Request $request, $id)
    {
        $data = $request->validate([
            'title.ar' => 'required|string|max:255',
            'title.en' => 'required|string|max:255',
            'duration' => 'required|integer|min:1',
            'price' => 'required|numeric|min:0',
        ]);

        $vendor = auth()->user();
        $inspection = $vendor->inspections()->findOrFail($id);

        $inspection->update([
            'title' => $request->title,
            'duration' => $request->duration,
            'price' => $request->price,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'تم تحديث الفحص بنجاح',
            'data' => $inspection,
        ]);
    }

    
    
    public function destroy($id)
    {
       $vendor = auth()->user();

       
        $exists = $vendor->inspections()->where('inspection_id', $id)->exists();

        if (!$exists) {
            return $this->apiResponse(false, 'Inspection not found for this vendor',[],[]);
        }

        $vendor->inspections()->detach($id);

        return $this->apiResponse(true, 'Inspection deleted successfully', [], ['inspection_id' => $id]);
    }
}
