<?php
namespace App\Http\Controllers\Provider;
use App\Http\Controllers\Controller;

use App\Models\CustomPartRequest;
use App\Traits\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\CustomPartRequestResource;
use App\Models\SparePartOffer;
use App\Http\Resources\OrderResource;
use App\Models\CartItem;
use App\Http\Resources\SparePartOfferResource;

class VendorOrderController extends Controller
{
    use ApiTrait;
 
    public function getVendorOrders()
    {
        $vendor = Auth::user();

        $orders = CartItem::whereHas('sparePart', function ($query) use ($vendor) {
            $query->where('vendor_id', $vendor->id);
        })->with('sparePart')->get();

      
        return $this->apiResponse(true, 'Vendor Orders retrieved successfully', [], OrderResource::collection($orders)->additional(['index_start' => 1]));
    }
   
    public function getVendorOffers()
    {
        $vendor = auth()->user();

        // Get only accepted offers for the auth vendor
        $offers = $vendor->sparePartOffers()
            ->where('status', 'accepted')
            ->latest()
            ->get();

        return $this->apiResponse(true, 'Offers retrieved successfully', [], SparePartOfferResource::collection($offers));
    }
}