<?php
namespace App\Http\Controllers\Provider;
use Illuminate\Http\Request;
use App\Models\VendorRepairIssue;
use App\Http\Controllers\Controller;
use App\Traits\ApiTrait;
use App\Models\RepairIssue;
class VendorRepairIssueController extends Controller
{
     use ApiTrait;
    /**
     * Store a new repair issue for the authenticated vendor.
     */
    public function index(){
          $vendor = auth()->user();
          $issues = $vendor->repairIssues()->get();
          return $this->apiResponse(true, 'vendor repire issue retrive successfully', [],$issues);


    }

    public function store(Request $request)
    {
        $request->validate([
            'title.ar' => 'required|string|max:255',
            'title.en' => 'required|string|max:255',
        ]);

        $vendor = auth()->user();

        $issue = $vendor->repairIssues()->create([
            'title' => $request->title,
            'repair_issue_id'=>$request->repair_issue_id
        ]);

        return response()->json([
            'status' => true,
            'message' => 'تم إضافة المشكلة بنجاح',
            'data' => $issue,
        ]);
    }

    /**
     * Delete a repair issue belonging to the authenticated vendor.
     */
    public function destroy($id)
    {
        $vendor = auth()->user();

        $issue = $vendor->repairIssues()->findOrFail($id);
        $issue->delete();

        return response()->json([
            'status' => true,
            'message' => 'تم حذف المشكلة بنجاح',
        ]);
    }
    public function getallRepairisssues(){
     
        $spiclization=RepairIssue::all();
        return $this->apiResponse(true, 'repire issue retrive successfully', [],$spiclization);

    }
    
}
