<?php
namespace App\Http\Controllers\Provider;

use Illuminate\Http\Request;
use App\Models\VendorTimetable;
use App\Http\Controllers\Controller;
use App\Traits\ApiTrait;
class VendorTimetableController extends Controller
{
      use ApiTrait;
    /**
     * Store a new repair issue for the authenticated vendor.
     */
    public function index(){
          $vendor = auth()->user();
          $timetables = $vendor->timetables()->get();
          return $this->apiResponse(true, 'vendor repire timetables retrive successfully', [],$timetables);


    }
  /*   public function store(Request $request)
    {
        $request->validate([
            'day_of_week' => 'required|string|in:sunday,monday,tuesday,wednesday,thursday,friday,saturday',
            'start_time' => 'required|date_format:H:i',
            'end_time' => 'required|date_format:H:i',
            'is_available' => 'required|boolean',
        ]);

        $vendor = auth()->user(); 

        $timetable = $vendor->timetables()->create([
            'day_of_week' => $request->day_of_week,
            'start_time' => $request->start_time,
            'end_time' => $request->end_time,
            'is_available' => $request->is_available,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'تم إنشاء الجدول الزمني بنجاح',
            'data' => $timetable,
        ]);
    } */
    public function store(Request $request)
   {
        $request->validate([
            'off_days' => 'required|array', 
            'start_time' => 'required|date_format:H:i', // وقت بداية الشغل
            'end_time' => 'required|date_format:H:i',   // وقت نهاية الشغل
        ]);

        $vendor = auth()->user();

        $allDays = ['sunday','monday','tuesday','wednesday','thursday','friday','saturday'];
        $offDays = $request->off_days;

        foreach ($allDays as $day) {
            if (in_array($day, $offDays)) {
                $vendor->timetables()
                    ->where('day_of_week', $day)
                    ->delete();
            } else {
               
                $vendor->timetables()->updateOrCreate(
                    ['day_of_week' => $day],
                    [
                        'is_available' => true,
                        'start_time' => $request->start_time,
                        'end_time' => $request->end_time,
                    ]
                );
            }
        }

        return response()->json([
            'status' => true,
            'message' => 'تم تحديث جدول العمل بنجاح ',
        ]);
    }

   
    public function update(Request $request)
    {
        $request->validate([
            'day_of_week' => 'required|string|in:sunday,monday,tuesday,wednesday,thursday,friday,saturday',
            'start_time' => 'required|date_format:H:i',
            'end_time' => 'required|date_format:H:i',
            'is_available' => 'required|boolean',
        ]);

        $vendor = auth()->user();

        $timetable = $vendor->timetables()
            ->where('day_of_week', $request->day_of_week)
            ->first();

        if ($timetable) {
            $timetable->update([
                'start_time' => $request->start_time,
                'end_time' => $request->end_time,
                'is_available' => $request->is_available,
            ]);
        } else {
            $timetable = $vendor->timetables()->create([
                'day_of_week' => $request->day_of_week,
                'start_time' => $request->start_time,
                'end_time' => $request->end_time,
                'is_available' => $request->is_available,
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'تم التحديث أو الإنشاء بنجاح',
            'data' => $timetable,
        ]);
    }
}
