<?php
namespace App\Http\Controllers\Provider;
use App\Http\Controllers\Controller;

use App\Models\CustomPartRequest;
use App\Traits\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\CustomPartRequestResource;
use App\Models\SparePartOffer;
use App\Http\Resources\OrderResource;
use App\Models\OrderItem;
use App\Http\Resources\SparePartOfferResource;

class WalletController extends Controller
{
    use ApiTrait;
 
    public function getWalletData()
    {
        $vendor = Auth::user();

        $orders = OrderItem::whereHas('sparePart', function ($query) use ($vendor) {
            $query->where('vendor_id', $vendor->id);
        })->with('sparePart')->get();
       
        $offers = $vendor->sparePartOffers()
            ->where('status', 'accepted')
            ->latest()
            ->get();


      
        return $this->apiResponse(true, 'Vendor Orders retrieved successfully', [],[ "orders"=>OrderResource::collection($orders)->additional(['index_start' => 1]),"offer_product"=>SparePartOfferResource::collection($offers)]);
    }
   
    public function getVendorOffers()
    {
        $vendor = auth()->user();

        // Get only accepted offers for the auth vendor
        $offers = $vendor->sparePartOffers()
            ->where('status', 'accepted')
            ->latest()
            ->get();

        return $this->apiResponse(true, 'Offers retrieved successfully', [], SparePartOfferResource::collection($offers));
    }
}