<?php

namespace App\Http\Requests\MobileApi;


use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreCustomPartRequest extends FormRequest
{
    public function authorize()
    {
        return auth()->check(); // Requires authentication
    }

    public function rules()
    {
        return [
            'model_id' => ['required', 'integer', 'exists:models,id'],
            'category_id' => ['required', 'integer', 'exists:categories,id'],
            'vendor_id' => ['required', 'integer', 'exists:vendors,id'],
            'description' => ['required', 'string', 'max:1000'],
            'status' => ['required', 'string', Rule::in(['pending', 'approved', 'rejected'])],
            'items' => ['required', 'array', 'min:1'],
            'items.*.name' => ['required', 'array'],
            'items.*.name.ar' => ['required', 'string', 'max:255'],
            'items.*.name.en' => ['required', 'string', 'max:255'],
            'items.*.quantity' => ['required', 'integer', 'min:1'],
            'items.*.notes' => ['nullable', 'string', 'max:1000'],
            'items.*.image' => ['nullable', 'string', 'url', 'max:255'],
        ];
    }

    public function messages()
    {
        return [
            'model_id.required' => [
                'en' => 'The model ID is required.',
                'ar' => 'معرف النموذج مطلوب.'
            ],
            'category_id.required' => [
                'en' => 'The category ID is required.',
                'ar' => 'معرف الفئة مطلوب.'
            ],
            'vendor_id.required' => [
                'en' => 'The vendor ID is required.',
                'ar' => 'معرف المورد مطلوب.'
            ],
            'description.required' => [
                'en' => 'The description is required.',
                'ar' => 'الوصف مطلوب.'
            ],
            'status.required' => [
                'en' => 'The status is required.',
                'ar' => 'الحالة مطلوبة.'
            ],
            'items.required' => [
                'en' => 'At least one item is required.',
                'ar' => 'مطلوب عنصر واحد على الأقل.'
            ],
            'items.*.name.required' => [
                'en' => 'Each item must have a name.',
                'ar' => 'يجب أن يحتوي كل عنصر على اسم.'
            ],
            'items.*.quantity.required' => [
                'en' => 'Each item must have a quantity.',
                'ar' => 'يجب أن يحتوي كل عنصر على كمية.'
            ],
        ];
    }
}