<?php

namespace App\Http\Requests\MobileApi;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserCarRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
    {
        return [
            'model_id' => 'required|exists:models,id',
            'manufacturing_year' => 'required|integer|min:1900|max:' . date('Y'),
            'engine' => 'required|string|max:255',
            'chassis_number' => 'required|string|unique:user_cars,chassis_number',
            'chassis_image' => 'nullable|image|mimes:jpg,png|max:2048',
            'car_image' => 'nullable|image|mimes:jpg,png|max:2048',
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ];
    }
}