<?php
namespace App\Http\Requests\Provider;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
class ProductRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
       
        return [
            'name' => 'required|string',
            'price' => 'required',
            'discount_percent' => 'nullable',
            'offer_starts_at' => 'nullable',
            'offer_ends_at' => 'nullable',
            'category_id'=>'nullable',
            'car_category_id'=>'nullable',
            'stock'=>'nullable',
            'condation'=>'nullable',
            'brand_id'=>'nullable',
            'model_id'=>'nullable',
            'warranty_period'=>'nullable',
            'origin_country'=>'nullable',
            'description'=>'nullable',
            'is_new'=>'nullable',
                'barcode' => 'nullable|unique:spare_parts,barcode',

        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'name is required.',
                'barcode.unique' => 'هذا الباركود مستخدم بالفعل',

          
        ];
    }
        protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json([
            'status' => false,
            'message' => 'Validation errors',
            'errors' => $validator->errors(),
        ], 422));
    }
}
