<?php

namespace App\Http\Requests\Provider;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class RegistrationRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:255',
            'email' => 'nullable|email|unique:vendors,email',
            'password' => 'required|string|min:6',
            'address' => 'required|string',
            'city_id' => 'required|exists:cities,id',
            'brand_ids'=>'required|array',
            'category_ids' => 'required|array',
            'category_ids.*' => 'exists:categories,id',
            'phone' => 'required|string',

        ];
    }
     public function messages(): array
    {
        return [
            'name.required' => 'Name is required.',
            'phone.required' => 'phone is required.',
            'email.email' => 'Email format is invalid.',
            'email.unique' => 'This email is already taken.',
            'password.required' => 'Password is required.',
            'password.min' => 'Password must be at least 6 characters.',
            'address.required' => 'Address is required.',
            'city_id.required' => 'City is required.',
            'city_id.exists' => 'Selected city does not exist.',
            'state_id.required' => 'State is required.',
            'state_id.exists' => 'Selected state does not exist.',
            'categories.required' => 'At least one category must be selected.',
            'categories.*.exists' => 'One or more selected categories are invalid.',
        ];
    }
      protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(response()->json([
            'status' => false,
            'message' => 'Validation errors',
            'errors' => $validator->errors(),
        ], 422));
    }
}
