<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AdvantageResource extends JsonResource
{
    protected $lang;

    public function __construct($resource, $lang = null)
    {
        parent::__construct($resource);
        $this->lang = $lang;
    }

    public function toArray(Request $request): array
    {
        $parseContent = function ($content) {
            $lines = preg_split("/\n-\s*/", $content);
            $lines = array_filter($lines);
            return array_values($lines);
        };

        if ($this->lang && in_array($this->lang, ['ar', 'en'])) {
            $title = $this->getTranslation('title', $this->lang);
            $content = $this->getTranslation('content', $this->lang);

            $points = $parseContent($content);

            return [
                'id' => $this->id,
                'title' => $title,
                'content' => $points,  // <-- Here content is an array of strings (the bullet points)
            ];
        }

        return [
            'id' => $this->id,
            'title' => $this->title,
            'content' => $this->content,
        ];
    }
}