<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AppointmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';
        return [
            'id' => $this->id,
            'user' => $this->user ? new UserResource($this->user) : null,
            'vendor' => $this->vendor ? new VendorResource($this->vendor) : null,
            'inception' => $this->inspection ? new InspectionResource($this->inspection) : null,
            'date' => $this->date ? $this->date->format('Y-m-d') : null,
            'start_time'=> $this->start_time ? $this->start_time->format('H:i') : null,
            'end_time'=> $this->end_time ? $this->end_time->format('H:i') : null

        ];
    }
}