<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BaseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function getTranslation(string $attribute, string $locale, bool $useFallbackLocale = true): ?string
    {
        if (!in_array($attribute, $this->translatable)) {
            return null;
        }

        $value = $this->getAttributes()[$attribute] ?? null;

        if (!$value) {
            return null;
        }

        $decoded = json_decode($value, true);
        if (!is_array($decoded)) {
            return null;
        }

        return $decoded[$locale] ?? ($useFallbackLocale ? ($decoded[config('app.fallback_locale')] ?? null) : null);
    }

}