<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BrandModelResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';
        return [
            'id' => $this->id,
            'name' => is_array($this->name) ? ($this->name[$locale] ?? null) : (
                json_decode($this->name, true)[$locale] ?? null
            ),
            'image' =>   asset('storage/' . $this->image),

            'models' => $this->models ? ModelResource::collection($this->models) : null,


        ];
    }
}