<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CarForSaleResource extends JsonResource
{
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', app()->getLocale());
        return [
            'id' => $this->id,
            'model' => new ModelResource($this->model),
            'image' => asset('storage/' . $this->image),
            'price' => $this->price,
            'mileage' => $this->mileage,
            'description' => $this->description,
            'inspection_location' => $this->city ? $this->city->governorate->getTranslation('name',$locale) .' / '. $this->city->name[$locale] : '',
            'is_whatsapp' => $this->is_whatsapp == 1  ? true : false,
            'phone_number' => $this->phone_number,
            'installment_available' => $this->installment_available,
            'negotiability'=>$this->negotiability == 1 ? true : false,
            'notes' => $this->notes,
            'style'=>$this->style?->getTranslation('name',$locale),
            'transmission_type' => $this->transmission_type,
            'production_year' => $this->production_year,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}