<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CityResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', app()->getLocale());
        return [
            'id' => $this->id,
             'name' => $this->name[$locale] ?? '',
            'governorate_id' => $this->governorate_id,
            'governorate_name'=>$this->governorate->getTranslation('name',$locale),
        ];
    }
}