<?php
namespace App\Http\Resources;

use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomPartRequestItemResource extends JsonResource
{
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        return [
            'id' => $this->id,
            'custom_part_request_id' => $this->custom_part_request_id,
            'name' => $this->name ?? null,
            'quantity' => $this->quantity,
            'notes' => $this->notes,
             
            'images' => FileResource::collection($this->images) ?? null,
            'offers'=>$this->itemOffers ? SparePartOfferResource::collection($this->itemOffers) : null,
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),

        ];
    }
}