<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class GovernorateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', app()->getLocale());
        return [
            'id' => $this->id,
             'name' =>$this->getTranslation('name',$locale)?? '',
            'cities' => CityResource::collection($this->whenLoaded('cities')),
        ];
    }
}