<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class InspectionResource extends JsonResource
{
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        return [
            'id' => $this->id,
             'title' => $this->resource->getTranslation('title',$locale) ?? '',
              'specialty'=>$this->speclity->getTranslation('title',$locale)
        ];
    }
}