<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderItemSpareResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'              => $this->id,
            'spare_part'      => new SparePartResource($this->whenLoaded('sparePart')),
            'quantity'        => $this->quantity,
            'unit_price'      => $this->unit_price,
            'has_discount'    => (bool) $this->has_discount,
            'discount_amount' => $this->discount_amount,
        ];
    }
}