<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    public function toArray($request)
    {
        
         static $orderIndex = 1;
            return [
            'id' => $this->id,
            'status' => $this->status,
            'total_price' => $this->unit_price * $this->quantity,
            'paid_amount' => $this->paid_amount,
            'remaining_amount' => $this->remaining_amount,
            'created_at' => $this->created_at ? $this->created_at->format('d/m/Y') : null,
            'order_number' => $orderIndex++,
        ];
    }
}