<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderSparpartResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'               => $this->id,
            'status'           => $this->status,
            'total_price'      => $this->total_price,
            'paid_amount'      => $this->paid_amount,
            'remaining_amount' => $this->remaining_amount,
            'shipping_address' => $this->shipping_address,
            'payment_method'   => $this->payment_method,
            'user'             => new UserResource($this->whenLoaded('user')),
            'items'            => OrderItemSpareResource::collection($this->whenLoaded('items')),
            'created_at'       => $this->created_at->toDateTimeString(),
        ];
    }
}
