<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

/* class PackageCategoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id'   => $this->id,
            'name' => $this->name,

           'products' => $this->spareParts
                ->where('pivot.package_id', $this->package_id)
                ->values() // 👈 هذا بيعيد ترتيب الـ keys متسلسلة
                ->map(function ($spare) {
                    return [
                        'item_id' => $spare->pivot->id,
                        'id'      => $spare->id,
                        'name'    => $spare->getTranslation('name','ar'),
                        'price'   => (int) $spare->price,
                        'is_main' => (bool) $spare->pivot->is_main,
                    ];
                }),
        ];
    }
}
 */
class PackageCategoryResource extends JsonResource
{
    public function toArray($request)
    {
        $packageId = $this->package_id; // ✅ هنا الحل

        $items = $this->packageItems()
            ->where('package_id', $packageId)
            ->with('product')
            ->get();

        return [
            'id'   => $this->id,
            'name' => $this->name,

            'products' => $items->map(function ($item) {
                return [
                    'item_id'         => $item->id,
                    'id'              => optional($item->product)->id,
                    'name'            => optional($item->product)?->getTranslation('name', 'ar'),
                    'price'           => (int) ($item->price ?? 0),
                    'is_main'         => (bool) $item->is_main,
                    'is_installation' => (bool) $item->is_installation,
                ];
            })->values(),
        ];
    }
}

