<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PackageItemResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'category' => $this->category->name ,
            'is_installation' => (bool) $this->is_installation,
            'is_main'=>(bool) $this->is_main,
            'product' => $this->when($this->product, function () {
                return [
                    'id' => $this->product->id,
                    'name' => $this->product->getTranslation('name','ar'),
                    'origenl_price' => (int) $this->product->price,
                    'copy_price' => $this->product->copy_price,
                ];
            }),
        ];
    }
}
