<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PackageResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'is_universal' => (bool) $this->is_universal,
            'total_price' => $this->mainProducts->sum('price'),
            'products' => $this->mainProducts->map(function($item) {
                            return [
                                'id' => $item->id,
                                'name' => $item->getTranslation('name', 'ar'),
                                'origenl_price' => (int) $item->price,
                                'is_installation' => (bool) $item->is_installation,
                                'is_main' => (bool) $item->is_main,
                            ];
                        }),
          'items' => PackageItemResource::collection($this->whenLoaded('items')),
        ];
    }
}
