<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PackageSubscribeResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
             'parent_package' => $this->package->parent->name,

             'package_name' => $this->package->name,
            'user_name' =>  $this->user->full_name,
            'package_id' => $this->package_id,
            'user_id' => $this->user_id,
            'total_price' => $this->total_price,
            'city'=>new CityResource($this->city),
            'model'=>new ModelResource($this->model),
            'note'=>$this->notes,
            'date'=>$this->date,
            'time'=>$this->time,
            'items' => PackageSubscribeItemResource::collection($this->whenLoaded('items')),
        ];
    }
}
