<?php
namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'name'   => $this->name,
            'price' => $this->price,
            'stock'   => $this->stock,
            'description'=>$this->description,
            'offer_starts_at' => $this->offer_starts_at,
            'offer_ends_at' => $this->offer_ends_at,
            'condition'   => $this->condition,
            'discount_percent' => $this->discount_percent ? $this->discount_percent . '%' : null,
            'origin_country' =>$this->origin_country,
            'warranty_period'=>$this->warranty_period,
            'category'=> new CategoryResource($this->category),
            'Brand'=> new BrandModelResource($this->brand),
            'model'=>new ModelResource($this->model),
            'car category'=>new CarCategoryResource($this->carCategory),
            'Owner'=>new VendorResource($this->vendor),
            'files'=>FileResource::collection($this->images),
          
            'description' => $this->description,
            'is_active' => $this->is_active,
            'capacity_ah' => $this->capacity_ah,
            'width' => $this->width,
            'aspect_ratio' => $this->aspect_ratio,
            'diameter' => $this->diameter,
            'viscosity' => $this->viscosity,
            'weight' => $this->weight,
            'centre_bore' => $this->centre_bore,
            'bolt_pattern' => $this->bolt_pattern,
            'brand_id' => $this->brand_id,
            'is_new'=>$this->is_new ?? '',
            'filters'=>SparePartFillter::collection($this->filters),


        ];
    }
}