<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ServiceCenterResource extends BaseResource
{
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        return [
            'id' => $this->id,
            'name' => $this->getTranslation('name', $locale),

            'email' => $this->email,
            'phone' => $this->phone,
            'city_id' => $this->city_id,
            'city_name' => $this->city ? (
                is_array($this->city->name) ? ($this->city->name[$locale] ?? null) : (
                    json_decode($this->city->name, true)[$locale] ?? null
                )
            ) : null,
            'address' => $this->address,
            'image' => $this->image ? asset('storage/' . $this->image) : null,            'description' => $this->description,
            'is_active' => (int) $this->is_active,
            'timetables' => VendorTimetableResource::collection($this->timetables),
            //'repair_issues' => RepairIssueResource::collection($this->repairIssues),
            'inspections' => InspectionResource::collection($this->inspections),
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
            'deleted_at' => $this->deleted_at?->toIso8601String(),
        ];
    }

}