<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SiteDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array
     */
    public function toArray(Request $request): array
    {
                $images = $this->images;
        return [
            'id' => $this->id,
            'key' => $this->key,
            'title' => $this->title,
            'short_description' => $this->short_description,
            'body' => $this->body,
            'image' => isset($images[0]) ? $images[0]->path : null,
            'image2' => isset($images[1]) ? $images[1]->path : null,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }
}