<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SparePartOfferResource extends JsonResource
{
   public function toArray($request)
    {
       /*  return [
            'id' => $this->id,
            'price' => $this->price,
            'status' => $this->status,
            'warranty_period' => $this->warranty_period,
            'paid_amount' => $this->paid_amount,
            'remaining_amount' => $this->remaining_amount,
            
            'created_at' => $this->created_at->format('d/m/Y'),
            // Add more fields if needed
        ]; */
        $data = [
                'id' => $this->id,
                'price' => $this->price,
                'status' => $this->status,
                'owner'=>new VendorResource($this->vendor),
                'warranty_period' => $this->warranty_period,
                'created_at' => $this->created_at->format('d/m/Y'),
            ];

            if ($this->status === 'pending') {
                $data['is_pending'] = true; // Add a flag or modify other fields here
            } else {
                $data['paid_amount'] = $this->paid_amount;
                $data['remaining_amount'] = $this->remaining_amount;
            }

            return $data;
    }

}