<?php

namespace App\Http\Resources;
use App\Models\Setting;
use Illuminate\Http\Resources\Json\JsonResource;

class SparePartResource extends JsonResource
{
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';
        $showVendor = Setting::getValue('show_vendor', 0);
        return [
            'id' => $this->id,
            'name' => $this->getTranslation('name', 'ar'),
            'category_id' => $this->category_id,
            'model_id' => $this->model_id,
            'category_name' => $this->category ? $this->category->getTranslation('name', $locale) : null,
            'vendor_id' => $this->vendor_id,
            'vendor_name' => $showVendor == 1
                ? $this->vendor?->getTranslation('name', $locale)
                : null,        
            'price' => $this->price,
            //'image' => $this->image,
            'stock'=>$this->stock,
            'origin_country' =>$this->origin_country,
            'warranty_period'=>$this->warranty_period,
            'description' => $this->description,
            'is_active' => $this->is_active,
            'capacity_ah' => $this->capacity_ah,
            'width' => $this->width,
            'aspect_ratio' => $this->aspect_ratio,
            'diameter' => $this->diameter,
            'viscosity' => $this->viscosity,
            'weight' => $this->weight,
            'centre_bore' => $this->centre_bore,
            'bolt_pattern' => $this->bolt_pattern,
            'brand_id' => $this->brand_id,
            'is_new'=>$this->is_new ?? '',
            'filters'=>SparePartFillter::collection($this->filters),
            'images'=>$this->images ? FileResource::collection($this->images) : null,
        ];
    }
}