<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class VendorResource extends BaseResource
{
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        return [
            'id' => $this->id,
            'name' => $this->getTranslation('name', $locale),
            'email' => $this->email,
            'phone' => $this->phone,
            'city_id' => $this->city_id,
            'city_name' => $this->city ? (
                is_array($this->city->name) ? ($this->city->name[$locale] ?? null) : (
                    json_decode($this->city->name, true)[$locale] ?? null
                )
            ) : null,
            'address' => $this->address,
            'image' => $this->image ? asset('storage/' . $this->image) : null,
            'description' => $this->description,
            'is_active' => $this->is_active,
            'timetables' => VendorTimetableResource::collection($this->whenLoaded('timetables')),
            'repair_issues' => RepairIssueResource::collection($this->whenLoaded('repairIssues')),
            'inspections' => InspectionResource::collection($this->whenLoaded('inspections')),
        ];
    }
}