<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class WinchResource extends JsonResource
{
    public function toArray($request)
    {
        //dd( $request->header('Accept-Language'));
            $locale = $request->header('Accept-Language', app()->getLocale());

        $statusText = '';
        if ($this->status === 'pending') {
            $statusText = $locale === 'ar' ? 'قيد الانتظار' : 'Pending';
        } elseif ($this->status === 'sended') {
            $statusText = $locale === 'ar' ? 'تم الإرسال' : 'Sent';
        } else {
            $statusText = $locale === 'ar' ? 'جاري معالجة الطلب' : 'Unknown';
        }
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'name' => $this->name,
            'phone_number' => $this->phone_number,
            'model' => $this->model ? new ModelResource($this->model) : ' ',
            'current_address' => $this->current_address,
            'destination_address' => $this->destination_address,
            'issue' => $this->issue,
            'status' =>$statusText,
            'hh'=>$this->status,

        ];
    }
}