<?php

namespace App\Listeners;

use App\Events\GoogelLogin;
use App\Services\UserNotificationService;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendPasswordMail; // مailable الذي سترسله
use App\Notifications\NewUserCreatedNotification; // notification

class SendWelcomeMail implements ShouldQueue
{
    use InteractsWithQueue;

    // handle يتم تنفيذه عند وقوع الحدث
    public function handle(GoogelLogin $event)
    {
        $user = $event->user;

        // لو المستخدم ما عندوش كلمة مرور محفوظة — نولّد ونسجّلها
        if (empty($user->password)) {
            $plainPassword = 'password';
            $user->password = Hash::make($plainPassword);
            $user->save();

            // أرسل الإيميل (مفضّل queue)
           // Mail::to($user->email)->queue(new SendPasswordMail($user, $plainPassword));

             $userNotifier = new UserNotificationService();
             $userNotifier->notifyGoogelLogin($user->id);
            // أرسل Notification (بما فيها database / mail / fcm حسب إعدادك)
           // $user->notify(new NewUserCreatedNotification($plainPassword));
        }
    }
}
