<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactResponseMail extends Mailable
{
    use Queueable, SerializesModels;

    public $contact;
    public $responseMessage;

    public function __construct($contact, $responseMessage)
    {
        $this->contact = $contact;
        $this->responseMessage = $responseMessage;
    }

    public function build()
    {
       return $this->from('support@part-mart.com', 'Team of Part Mart') // set header name here
                ->subject('رد على رسالتك')
                ->markdown('emails.response')
                ->with([
                    'name' => $this->contact->name,
                    'messageContent' => $this->contact->message,
                    'responseMessage' => $this->responseMessage,
                ]);
    }
}
