<?php
namespace App\Mail;


use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class HelpMessageMail extends Mailable
{
    use Queueable, SerializesModels;

    public $name;
    public $messageContent;


    public function __construct($name, $messageContent)
    {
        $this->name = $name;
        $this->messageContent = $messageContent;
     
    }

    public function build()
    {
        return $this->subject('رسالة جديدة من المستخدم')
                    ->markdown('emails.help_message')
                    ->with([
                        'name' => $this->name,
                        'messageContent' => $this->messageContent,
                       
                    ]);
    }
}
