<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SendPasswordMail extends Mailable
{
    use Queueable, SerializesModels;

    public $plainPassword;
    public $user;

    public function __construct($user, $plainPassword)
    {
        $this->user = $user;
        $this->plainPassword = $plainPassword;
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Welcome — Your Account Password',
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.welcome_password',
            with: [
                'name'     => $this->user->full_name ?? $this->user->name ?? $this->user->email,
                'email'    => $this->user->email,
                'password' => $this->plainPassword,
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
