<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;


class CarModel extends Model
{
    use HasFactory,HasTranslations;

    protected $fillable = ['name', 'year', 'brand_id', 'car_category_id','active'];
    // protected $casts = [
    //     'name' => 'array',
    // ];
    protected $table = 'models';
    public $translatable = ['name'];


    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }
    public function carCategory()
    {
        return $this->belongsTo(CarCategory::class);
    }

  /*   public function spareParts()
    {
        return $this->hasMany(SparePart::class);
    } */


   public function spareParts()
{
    return $this->belongsToMany(
        SparePart::class,   // Model المرتبط
        'sparepart_model',  // Pivot table
        'car_model_id',     // FK في pivot يشاور على models.id
        'spare_part_id',    // FK في pivot يشاور على spare_parts.id
        'id',               // Local key في models
        'id'                // Local key في spare_parts
    )
    ->withPivot('id')
    ->withTimestamps();
}


    public function carsForSale()
    {
        return $this->hasMany(CarForSale::class);
    }

    public function userCars()
    {
        return $this->hasMany(UserCar::class);
    }

    public function customPartRequests()
    {
        return $this->hasMany(CustomPartRequest::class);
    }
    public function packages()
    {
        return $this->belongsToMany(Package::class, 'car_model_package');
    }
}