<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CartItem extends Model
{
    use HasFactory;

    protected $fillable = ['spare_part_id', 'cart_id', 'quantity', 'price'];

    public function sparePart()
    {
        return $this->belongsTo(SparePart::class);
    }

    public function cart()
    {
        return $this->belongsTo(Cart::class);
    }
     public function payments()
    {
        return $this->hasMany(OrderPayment::class,'order_id');
    }

    public function getPaidAmountAttribute()
    {
        return $this->payments()->sum('amount');
    }

    public function getRemainingAmountAttribute()
    {
        return $this->price - $this->paid_amount;
    }
}