<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Category extends Model
{

    use HasFactory, HasTranslations;

    protected $fillable = ['name', 'is_active', 'image', 'parent_id'];

    public $translatable = ['name'];

    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    public function spareParts()
    {
        return $this->hasMany(SparePart::class);
    }

    public function customPartRequests()
    {
        return $this->hasMany(CustomPartRequest::class);
    }
    public function filters()
    {
        return $this->hasMany(CategoryFilter::class,'category_id');
    }
}