<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    protected $fillable = [
        'code', 'type', 'value', 'max_usage', 'used_count', 'expires_at', 'is_active'
    ];
        protected $casts = [
        'expires_at' => 'datetime',
    ];

    public function isValid(): bool
    {
        if (!$this->is_active) return false;

        if ($this->expires_at && $this->expires_at < now()) return false;

        if ($this->max_usage && $this->used_count >= $this->max_usage) return false;

        return true;
    }
}
