<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomPartRequest extends Model
{
    use HasFactory;

    protected $fillable = ['model_id', 'category_id', 'vendor_id', 'description', 'status', 'user_id', 'address','city_id','request_price'];

    public function model()
    {
        return $this->belongsTo(CarModel::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function items()
    {
        return $this->hasMany(CustomPartRequestItem::class);
    }

    public function notifications()
    {
        return $this->morphMany(Notification::class, 'related');
    }
    public function sparePartOffers()
    {
        return $this->hasMany(SparePartOffer::class, 'custom_part_request_id');
    }
      public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }

}