<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomPartRequestItem extends Model
{
    use HasFactory;

    protected $fillable = ['custom_part_request_id', 'name', 'quantity', 'notes', 'image','status','order_price'];

    public function customPartRequest()
    {
        return $this->belongsTo(CustomPartRequest::class);
    }
      public function itemOffers()
    {
        return $this->hasMany(SparePartOffer::class, 'item_id');
    }
    public function images()
    {
        return $this->hasMany(ItemImage::class,'item_id');
    }
        public function acceptedOffer()
    {
        return $this->hasOne(SparePartOffer::class, 'item_id')
            ->where('status', 'accepted')
            ->latest('id'); // or by 'created_at' if you want the latest accepted
    }

    /**
     * Get the price of the accepted offer or null if none.
     */
    public function getAcceptedOfferPriceAttribute()
    {
        return $this->acceptedOffer()->value('price');
    }

}