<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Translatable\HasTranslations;
class Inspection extends Model
{
    use HasFactory,HasTranslations;

    protected $table = 'inspections';

    protected $fillable = [
        'title',
        'specialty_id'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    public $translatable = ['title'];

    public function speclity()
    {
        return $this->belongsTo(Specialty::class,'specialty_id');
    }

    public function inspector()
    {
        return $this->belongsTo(Vendor::class, 'inspector_id');
    }

    public function vendors()
    {
        return $this->belongsToMany(Vendor::class, 'vendor_inspection')
            ->withTimestamps();
    }
}