<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Translatable;
use Spatie\Translatable\HasTranslations;


class ModelSlider extends Model
{
    use Translatable,HasTranslations;

    protected $fillable = ['model_id', 'image_url', 'title', 'order', 'is_active','vendor_id','spare_part_id'];

  /*   protected $casts = [
        'title' => 'array',
        'is_active' => 'boolean',
    ]; */
     public $translatable = ['title'];

    public function model()
    {
        return $this->belongsTo(Model::class);
    }
    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }
    public function getTitleAttribute($value)
    {
        return $this->translateName($value);
    }
}