<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'vendor_id',
        'title',
        'message',
        'is_read',
        'type',
        'read_at',
        'related_id',
        'related_type'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function admin()
    {
        return $this->belongsTo(Admin::class, 'user_id');
    }
    public function vendor(){
      return $this->belongsTo(Vendor::class, 'user_id');
    }

    public function related()
    {
        return $this->morphTo();
    }
}