<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class OrderItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'spare_part_id',
        'order_id',
        'quantity',
        'unit_price',
        'has_discount',
        'discount_amount'
    ];

    public function sparePart()
    {
        return $this->belongsTo(SparePart::class,'spare_part_id');
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }
     public function payments()
    {
        return $this->hasMany(OrderPayment::class,'order_id');
    }

    public function getPaidAmountAttribute()
    {
        return $this->payments()->sum('amount');
    }

    public function getRemainingAmountAttribute()
    {
        return ($this->unit_price*$this->quantity) - $this->paid_amount;
    }
}