<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use ParentIterator;


class Package extends Model
{
    protected $fillable = ['name', 'description', 'is_universal','parent_id'];

    public function items()
    {
        return $this->hasMany(PackageItem::class,'package_id');
    }


    public function packages(){
        return $this->hasMany(Package::class,'parent_id');
 
    }
     public function parent(){
        return $this->belongsTO(Package::class,'parent_id');
 
    }

    public function carModels()
    {
        return $this->belongsToMany(CarModel::class, 'car_model_packagas');
    }

    public function categories()
    {
        return $this->belongsToMany(
            PackageCategory::class,
            'package_items',
            'package_id',
            'package_category_id'
        )
        ->distinct();
    }


    public function mainProducts()
    {
        return $this->hasManyThrough(
            SparePart::class,
            PackageItem::class,
            'package_id',   // FK في package_items
            'id',           // PK في products
            'id',           // PK في package
            'spare_part_id'    // FK في package_items يشير للمنتج
        )->where('package_items.is_main', true); // شرط is_main
    }

    public function relatedProducts()
{
    return $this->belongsToMany(
        SparePart::class,
        'package_related_products',
        'package_id',
        'product_id'
    );
}

}
