<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageCategory extends Model
{
    use HasFactory;

    protected $table = 'package_categories';

    protected $fillable = [
        'name',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        // لو حابب بعدين تخلي الاسم JSON
        // 'name' => 'array',
    ];

    /**
     * المنتجات التابعة للفئة
     */
    public function products()
    {
        return $this->belongsToMany(
            Product::class,
            'product_package_category',
            'package_category_id',
            'product_id'
        )->withTimestamps();
    }

    /**
     * عناصر الحزم (لو عندك package_items)
     */
    public function packageItems()
    {
        return $this->hasMany(
            PackageItem::class,
            'package_category_id'
        );
    }

    public function spareParts()
{
    return $this->belongsToMany(
        SparePart::class,
        'package_items',
        'package_category_id', // FK هنا
        'spare_part_id'        // FK هنا
    )->withPivot([
        'id',
        'package_id',
        'is_main',
        'insatlation_price',
        'is_installation',
        'name'
    ])->withTimestamps();
}
}
