<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
class PackageItem extends Model
{
    protected $fillable = ['package_category_id', 'spare_part_id','product_services_id','is_main' ,'name', 'price', 'is_installation','package_id'];

    public function category()
    {
        return $this->belongsTo(PackageCategory::class,'package_category_id');
    }

    public function product()
    {
        return $this->belongsTo(SparePart::class,'spare_part_id');
    }
  
    public function service()
    {
        return $this->belongsTo(ProductService::class,'product_services_id');
    }
}